## How to report a bug

Read the following before reporting a bug on GitHub:

1. Update Lychee to the newest version
2. Update your browser to the newest version
2. Take a look in the [FAQ](https://github.com/electerious/Lychee/blob/master/docs/FAQ.md)
3. Check if someone has [already reported](https://github.com/electerious/Lychee/issues) the same bug

When reporting a bug on GitHub, make sure you include the following information:

- Detailed description of the problem
- How to reproduce the issue (step-by-step)
- What you have already tried
- Output of the diagnostics (`plugins/Diagnostics/index.php`)
- Browser and system version
- Attach files when you have problems which specific photos

## Coding Guidelines

Check if there are branches newer than `master`. Always fork the newest available branch.

Please follow the conventions already established in the code.

- **Spacing**:<br>
  Use tabs for indentation. Spaces for alignment.

- **Naming**:<br>
  Keep variable and method names concise and descriptive.

- **Quotes**:<br>
  Single-quoted strings are preferred to double-quoted strings

- **Comments**:<br>
  Please use single-line comments to annotate significant additions. Use `//` for comments in PHP, JS and CSS.

Merge your changes when the forked branch has been updated in the meanwhile. Make sure your code is 100% working before creating a Pull-Request on GitHub.