<!doctype html>
<!--[if lte IE 6]><html class="preIE7 preIE8 preIE9"><![endif]-->
<!--[if IE 7]><html class="preIE8 preIE9"><![endif]-->
<!--[if IE 8]><html class="preIE9"><![endif]-->
<!--[if gte IE 9]><!--><html><!--<![endif]-->
<html class="no-js" lang="">

<head>
  <meta charset="utf-8">
  <meta http-equiv="x-ua-compatible" content="ie=edge,chrome=1">
  <title></title>
  <meta name="description" content="">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <meta name="author" content="name">
  <meta name="description" content="description here">
  <meta name="keywords" content="keywords,here">
  
  <link rel="manifest" href="site.webmanifest">
  <link rel="apple-touch-icon" href="icon.png">
  <!-- Place favicon.ico in the root directory -->

  <link rel="stylesheet" href="//fonts.googleapis.com/css?family=font1|font2|etc" type="text/css">

  <link rel="stylesheet" href="css/normalize.css">
  <link rel="stylesheet" href="css/main.css">
  
  <link rel="stylesheet" href="https://unpkg.com/leaflet@1.3.4/dist/leaflet.css"
  integrity="sha512-puBpdR0798OZvTTbP4A8Ix/l+A4dHDD0DGqYW6RQ+9jxkRFclaxxQb/SJAWZfWAkuyeQUytO7+7N4QKrDh+drA=="
  crossorigin=""/>

   <!-- Make sure you put this AFTER Leaflet's CSS -->
 <script src="https://unpkg.com/leaflet@1.3.4/dist/leaflet.js"
 integrity="sha512-nMMmRyTVoLYqjP9hrbed9S+FzjZHW5gY1TWCHA5ckwXZBadntCNs8kEqAWdrb9O7rxbCaA4lKTIWjDXZxflOcA=="
 crossorigin=""></script>

 <script src="https://unpkg.com/leaflet" type="text/javascript"></script>
<script src="https://unpkg.com/leaflet-ant-path" type="text/javascript"></script>
</head>

<body>
  <!--[if lte IE 9]>
    <p class="browserupgrade">You are using an <strong>outdated</strong> browser. Please <a href="https://browsehappy.com/">upgrade your browser</a> to improve your experience and security.</p>
  <![endif]-->

  <!-- Add your site or application content here -->
  <!--<p>Hello world! This is HTML5 Boilerplate.</p>-->

  <!--<div id="mapid" style="width: 600px; height: 400px;"></div>-->

  <div id="map" style="width: 80%; height: 80%; position: absolute;"></div>

  <!-- Footer Javascript -->
  <script src="js/vendor/modernizr-3.6.0.min.js"></script>
  <script src="https://code.jquery.com/jquery-3.3.1.min.js" integrity="sha256-FgpCb/KJQlLNfOu91ta32o/NMZxltwRo8QtmkMRdAu8=" crossorigin="anonymous"></script>
  <script src="js/snap.svg-min.js"></script>
  <script src="js/leaflet.bezier.js" crossorigin=""></script>
  <script>window.jQuery || document.write('<script src="js/vendor/jquery-3.3.1.min.js"><\/script>')</script>
  <script type="text/javascript">
    function autorun()
    {
     
    }
    if (document.addEventListener) document.addEventListener("DOMContentLoaded", autorun, false);
    else if (document.attachEvent) document.attachEvent("onreadystatechange", autorun);
    else window.onload = autorun;
   </script>
 
  <script src="js/plugins.js"></script>
  <script src="js/main.js"></script>
  
  <script>

  var latlngs = [
[22.9761, 113.7799],
[15.0000, -86.5000],
[-34.0152, 21.7617],
[34.9619, 105.0952]
];
    var country = L.layerGroup();
  
    L.marker([22.9761, 113.7799]).bindPopup('<b>China<br /><a href="video.html">Video</a></b>').addTo(country),
    L.marker([15.0000, -86.5000]).bindPopup('Honduras').addTo(country),
    L.marker([-34.0152, 21.7617]).bindPopup('South Africa').addTo(country);
  
    var mbAttr = 'Map data &copy; <a href="https://www.openstreetmap.org/">OpenStreetMap</a> contributors, ' +
        '<a href="https://creativecommons.org/licenses/by-sa/2.0/">CC-BY-SA</a>, ' +
        'Imagery © <a href="https://www.mapbox.com/">Mapbox</a>',
      mbUrl = 'https://api.tiles.mapbox.com/v4/{id}/{z}/{x}/{y}.png?access_token=pk.eyJ1IjoibWFwYm94IiwiYSI6ImNpejY4NXVycTA2emYycXBndHRqcmZ3N3gifQ.rJcFIG214AriISLbB6B5aw';
  
    var grayscale   = L.tileLayer(mbUrl, {id: 'mapbox.light', attribution: mbAttr}),
      streets  = L.tileLayer(mbUrl, {id: 'mapbox.streets',   attribution: mbAttr});
  
    var map = L.map('map', {
      center: [7.5000, 30.0000],
      zoom: 3,
      layers: [grayscale, country]
    });
  
    var baseLayers = {
      "Grayscale": grayscale,
      "Streets": streets
    };
  
    var overlays = {
      "Country": country
    };
  
    //L.control.layers(baseLayers, overlays).addTo(map);

    //Using the factory
    /*const path = antPath(route,
    {"delay":195,"dashArray":[10,20],"weight":5,"color":"#FF0004","pulseColor":"#000000","paused":false,"reverse":false}
    );*/
    const path = L.polyline.antPath(latlngs, {"delay":195,"dashArray":[10,20],"weight":5,"color":"#FF0004","pulseColor":"#000000","paused":false,"reverse":false});
    //path.addTo(map);

        var dash_straight = {
        color: 'rgb(0, 38, 190)',
        fillColor: 'rgb(0, 38, 190)',
        dashArray: 3,
        opacity: 0.75,
        weight: '3',
    };

    L.bezier({
        path: [
            [
                {lat: 22.9761, lng: 113.7799},//Sri Lanka
                {lat: 15.0000, lng: -86.5000},//Australia
            ],
            [
                {lat: 15.0000, lng: -86.5000},//Sri Lanka
                {lat: -34.0152, lng: 21.7617}
            ],
            [
                {lat: -34.0152, lng: 21.7617, slide: 'RIGHT_ROUND',deep:"8"},//Sri Lanka
                {lat: 22.9761, lng: 113.7799}
            ]
        ],

        icon: {
            path: "js/plane.png"
        }
    }, dash_straight).addTo(map);


var greenIcon = L.icon({
    iconUrl: 'js/ship.png',

    iconSize:     [30, 30], // size of the icon
    iconAnchor:   [22, 94], // point of the icon which will correspond to marker's location
});
L.marker([-12.665, 2.813], {icon: greenIcon}).addTo(map);
L.marker([-14.264, 69.082], {icon: greenIcon}).addTo(map);
L.marker([-30.145, -26.631], {icon: greenIcon}).addTo(map);
  </script>

</body>

</html>
